require( "quest/mg_pizza/convout.lua" );
combine_speech_tables();

round_num = 
{
	1, -- round one
};

initial_setup = true;
show_activity_text = false;

local puzzlePieces = { nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil };
local currentHighlightedIndex = 0;
local highlight = nil;
--local winMessage = nil;
local activity_done = false;

local puzzleFormatInfo = 
{
	xOffset = 79,
	yOffset = 68,
	pieceWidth = 105, 
	pieceHeight = 90,
	gridWidth = 6,
	gridHeight = 4
};

local puzzlePieceInfo = 
{
	image = "puzzlePiece",
	highlighted = "puzzlePieceHighlighted"
};

local puzzleInfo = 
{
	startPos = { 9, 7, 13, 4, 6, 8, 14, 18, 17, 10, 12, 5, 21, 22, 23, 20, 2, 11, 16, 15, 3, 24, 19, 1 };
}
--[[
local winMessageInfo =
{
	message = "Champion",
	offset = { x = 365, y =200 };
};
--]]
function spawnPuzzle()	
	for index = 1, puzzleFormatInfo.gridHeight * puzzleFormatInfo.gridWidth do
		local startIndex = puzzleInfo.startPos[index];			
		local puzzlePiece = get_puzzlePiece_item_spec( "puzzlePiece" .. tostring(index), puzzlePieceInfo.image .. tostring(index), GetPosFromIndex(startIndex), index, startIndex );
		puzzlePieces[startIndex] = scene:Spawn(puzzlePiece);				
	end
	highlight = scene:Spawn( get_generic_item_spec( "highlight", puzzlePieceInfo.highlighted, GetPosFromIndex(0) ) );
	highlight:SetDepthValue(3);
	CheckForWin();
	--winMessage = scene:Spawn( get_generic_item_spec( "winMessage", "", winMessageInfo.offset ) );	
end

function JumblePieces()
	local tempPuzzlePieces = { nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil, nil };
	for index = 1, puzzleFormatInfo.gridHeight * puzzleFormatInfo.gridWidth do
		tempPuzzlePieces[index] = puzzlePieces[index];
	end
	for index = 1, puzzleFormatInfo.gridHeight * puzzleFormatInfo.gridWidth do
		local startIndex = puzzleInfo.startPos[tempPuzzlePieces[index].index];		
		puzzlePieces[startIndex] = tempPuzzlePieces[index];
		puzzlePieces[startIndex]:JumpToPoint( GetPosFromIndex(startIndex) );
		puzzlePieces[startIndex].currentIndex = startIndex;
	end
end

function GetIndex( i, j )
	local index = ( ( i - 1 ) * puzzleFormatInfo.gridWidth ) + j;
	return index;
end

function GetPosFromIndex( index )
	local xOffset = fmod( ( index - 1 ), puzzleFormatInfo.gridWidth ) * puzzleFormatInfo.pieceWidth + puzzleFormatInfo.xOffset;
	local yOffset = math.floor( ( index - 1 ) / puzzleFormatInfo.gridWidth ) * puzzleFormatInfo.pieceHeight + puzzleFormatInfo.yOffset;
	local offset = { x = xOffset, y = yOffset };	
	return offset;
end

function SwapPieces( piece1, piece2 )
	local temp = puzzlePieces[piece2];
	puzzlePieces[piece2] = puzzlePieces[piece1];
	puzzlePieces[piece1] = temp;
	puzzlePieces[piece1].currentIndex = piece1;
	puzzlePieces[piece2].currentIndex = piece2;
	puzzlePieces[piece1]:JumpToPoint( GetPosFromIndex( piece1 ) );
	puzzlePieces[piece1].selectedImage:JumpToPoint( GetPosFromIndex( piece1 ) );
	puzzlePieces[piece2]:JumpToPoint( GetPosFromIndex( piece2 ) );	
	puzzlePieces[piece2].selectedImage:JumpToPoint( GetPosFromIndex( piece2 ) );
end

function CheckForWin()
	local solved = true;
	for i = 1, puzzleFormatInfo.gridHeight * puzzleFormatInfo.gridWidth do
		if ( puzzlePieces[i].currentIndex ~= puzzlePieces[i].index ) then
			solved = false;
		else
			if puzzlePieces[i].selectedImage then
				puzzlePieces[i]:DumpZone();
				puzzlePieces[i].selectedImage:Expire();
				puzzlePieces[i].selectedImage = nil;
				sfx:PlaySFX("audio/sfx/dress_reward");
			end
		end
	end
	return solved;
end

function get_puzzlePiece_item_spec(_name, _image, pos, index, startIndex ) 
	return
	{
		name = _name;
		halo = "puzzlepiece";
		gfx = { image = _image };
	
		command = function(actor)
			actor:SetDepthValue(1);
			actor:JumpToPoint( pos );
			actor:SetAlpha(1);
			actor.index = index;
			actor.currentIndex = startIndex;
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 30,
				x = -15,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
				font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor.selectedImage = scene:Spawn(get_generic_item_spec(_name .. "_SELECTED", "puzzlePieceSelectable", GetPosFromIndex(actor.currentIndex)));
			actor.selectedImage:SetDepthValue(2);
			actor.selectedImage:SetAlpha(1);
			actor.on_click = function()
				if ( activity_done ) then
					return;
				end
				-- handle highlighting
				if ( currentHighlightedIndex == actor.currentIndex ) then
					currentHighlightedIndex = 0;
					highlight:SetAlpha( 0 );
					sfx:PlaySFX("audio/sfx/pizza_pickup");
				elseif ( currentHighlightedIndex == 0 ) then
					currentHighlightedIndex = actor.currentIndex;
					highlight:JumpToPoint( GetPosFromIndex( actor.currentIndex ) );
					highlight:SetAlpha( 1 );
					sfx:PlaySFX("audio/sfx/pizza_pickup");
				-- and piece-swapping
				else
					sfx:PlaySFX("audio/sfx/pizza_swap");
					SwapPieces( currentHighlightedIndex, actor.currentIndex );
					currentHighlightedIndex = 0;
					highlight:SetAlpha( 0 );
					if ( CheckForWin() == true ) then
						activity_done = true;
						--[[
						winMessage:SetAlpha( 1 );
						winMessage:ModifySaySpec
						{
							color = { a = 1, r = 0, g = 0, b = 1 },							
							w = 500,							
							h = 300,
							x = -225,
							lineheight = 100,
							outline_color = { a = 1, r = 0, g = 0, b = 1 },							
							outline_size = 5,
						};
						winMessage:SayRaw( winMessageInfo.message );
						--]]
						scene.FLO:StartProc(activity_passed);
					end
				end
			end;
		end;
	}
end

function get_generic_item_spec(_name, _image, pos ) 
	return
	{
		name = _name;
		halo = "";
		gfx = { image = _image };
	
		command = function(actor)
			actor:SetDepthValue(1);
			actor:JumpToPoint( pos );
			actor:SetPointAtCursor("cursor");
			actor:SetAlpha(0);
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 30,
				x = -15,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
				font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
		end;
	}
end

function setup_activity()
	local activityNum = game:Get("mg_pizza_activity_num");
	local activityRound = game:Get("mg_pizza_activity_round");
	
	if initial_setup then
		if show_activity_text == true then
			scene:Spawn(activity_title_spec);
			scene:Spawn(round_num_spec);
			scene:Spawn(activity_num_spec);
		end
		initial_setup = false;
		coroutine.yield(RESUME.NOW);
		
		if activityNum == 1 and activityRound == 1 then
			help_panel_say_raw(scene:grabstring("tutorial_1"));
		else
			help_panel_say_raw(scene:grabstring("help_" .. tostring(activityRound) .. "_" .. tostring(activityNum)));
		end
	else
	end
	
	if show_activity_text == true then
		scene.ACTIVITY_NUM:SayRaw(scene:grabstring("activity") .. " " .. tostring(activityNum));
		scene.ROUND_NUM:SayRaw(scene:grabstring("round") .. " " .. tostring(activityRound));
	end
	
	activity_done = false;
	spawnPuzzle();
end;

function next_activity(flo)
	local activityNum = game:Get("mg_pizza_activity_num");
	local activityRound = game:Get("mg_pizza_activity_round");
	local roundComplete = activityNum == 1; -- on next round
	
	if roundComplete then
		scene:SetFadeTarget { a = 1, r = 0, g = 0, b = 0 };
		scene:SetFadeSpeed(0.05);
		scene:SetMusicVolumeSpeed(0.05);
		wait_fade();
		
		sfx:SetMusic("audio/music/music_delivery_movies.ogg", true);
		scene:DisplayFlash("flash/closingmovie1_intro.swf");
		wait_subscene();	
		
		scene:ChainTo("mg_doughball");
	else
		scene.NEXT_ACTIVITY_BUTTON:Expire();
		
		if IsCheatMode() then
			spawn_button(pass_activity_button_spec);
			spawn_button(fail_activity_button_spec);
		end
		
		spawn_button(hint_button_spec);
		move_actor_y(scene.HINT_BUTTON, -hud_lower_offset);
		
		-- load new puzzle
		setup_activity();
	end
end;

function activity_passed(flo)
	local activityNum = game:Get("mg_pizza_activity_num");
	local activityRound = game:Get("mg_pizza_activity_round");
	local roundComplete = activityNum == round_num[activityRound];
	
	if IsCheatMode() then
		scene.PASS_ACTIVITY_BUTTON:Expire();
		scene.FAIL_ACTIVITY_BUTTON:Expire();
	end
	
	scene.HINT_BUTTON:Expire();
	spawn_button(next_activity_button_spec);
	scene.NEXT_ACTIVITY_BUTTON:StartProc(pulse_actor);
	
	help_panel_say_raw(
		scene:grabstring("help_" .. tostring(activityNum) .. "_" .. tostring(activityRound)));
	
	if roundComplete then	
		if activityRound == 1 then
			game:Set("mg_pizza_activity_round", 2);
			game:Set("mg_pizza_activity_num", 1);
		else -- round == 2
			game:Set("mg_pizza_activity_round", 3);
			game:Set("mg_pizza_activity_num", 1);
		end
	else
		game:Set("mg_pizza_activity_num", activityNum + 1);
	end
	
	-- save progress
	--game:SaveGame();
	
	spawn_activity_complete_text("activity_complete_text", "audio/sfx/pizza_done");
	coroutine.yield(RESUME.ON_SIGNAL);
end;

function fail_activity(flo)
	JumblePieces();	
end;

flo_spec =
{
	name = "FLO";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
};

activity_title_spec = 
{
	name = "ACTIVITY_TITLE";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 10 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 40,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
		actor:SayRaw(scene:grabstring("activity_title"));
	end;
};

round_num_spec = 
{
	name = "ROUND_NUM";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 60 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 30,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
	end;
};

activity_num_spec = 
{
	name = "ACTIVITY_NUM";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 120 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 30,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
	end;
};

function pass_activity(flo)
	flo:StartProc(activity_passed);
end

function go_back(flo)
	kill_help_panel();
	goto_scene(flo, "m3_ship");
end

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/music_pizza.ogg", true);
		scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
		game:ClearInvUsage();
		
		fade_scene_up(true);
		lower_hud();
		spawn_button(hint_button_spec);
		spawn_help_panel();
		scene.BACK_BUTTON:Expire();
		
		if IsCheatMode() then
			-- testing data
			spawn_button(pass_activity_button_spec);
			spawn_button(fail_activity_button_spec);
		end
		
		-- set up for initial play
		if game:Get("mg_pizza_activity_num") < 1 then
			game:Set("mg_pizza_activity_num", 1);
		end
		
		if game:Get("mg_pizza_activity_round") < 1 then
			game:Set("mg_pizza_activity_round", 1);
		end
		
		setup_activity();
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces" -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		--{ "objects", 5 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		flo_spec, -- the main actor
		scene_setup,
	};
};
